<?php
/**
 * leopardAusgezeichnetOrg
 * Copyright (c) Die Leoparden e.K.
 */

namespace leopardAusgezeichnetOrg;

use Exception;
use Shopware\Bundle\AttributeBundle\Service\CrudService;
use Shopware\Components\Logger;
use Shopware\Components\Model\ModelManager;
use Shopware\Components\Plugin;
use Shopware\Components\Plugin\Context\ActivateContext;
use Shopware\Components\Plugin\Context\DeactivateContext;
use Shopware\Components\Plugin\Context\InstallContext;
use Shopware\Components\Plugin\Context\UninstallContext;
use Shopware\Components\Plugin\Context\UpdateContext;
use Shopware\Models\Mail\Mail;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Throwable;

/**
 * Shopware-Plugin leopardAusgezeichnetOrg.
 */
class leopardAusgezeichnetOrg extends Plugin
{
    /**
     * @var Logger
     */
    private $logger;

    /**
     * @param ContainerBuilder $container
     *
     * @throws Throwable
     */
    public function build(ContainerBuilder $container)
    {
        $this->logger = $container->get('pluginlogger');
        $container->setParameter('leopard_ausgezeichnet_org.plugin_dir', $this->getPath());

        parent::build($container);
    }

    /**
     * @param InstallContext $context
     */
    public function install(InstallContext $context)
    {
        $mailTemplate = Shopware()->Models()->getRepository('Shopware\Models\Mail\Mail')->findOneBy(['name' => 'ausgezeichnetorgEmail']);

        if (!$mailTemplate instanceof Mail) {
            $mailTemplateContent = file_get_contents(__DIR__ . '/Resources/Mail/sOrderleopardAusgezeichnetOrg.html');

            $mailTemplate = new Mail();
            $mailTemplate->setIsHtml(true);
            $mailTemplate->setName('ausgezeichnetorgEmail');
            $mailTemplate->setFromMail('{config name=mail}');
            $mailTemplate->setFromName('{config name=shopName}');
            $mailTemplate->setSubject('Bitte bewerten Sie uns!');
            $mailTemplate->setContentHtml($mailTemplateContent);
            $mailTemplate->setMailtype(Mail::MAILTYPE_USER);

            try {
                /** @var ModelManager $entityManager */
                $entityManager = Shopware()->Models();
                $entityManager->persist($mailTemplate);
                $entityManager->flush();
            } catch (Exception $e) {
                $this->logger->addError($e->getMessage());
            }
        }

        /** @var CrudService $attributeService */
        $attributeService = Shopware()->Container()->get('shopware_attribute.crud_service');
        $attribute = $attributeService->get('s_order_attributes', 'leopard_ausgezeichnet_org_status');

        if (!$attribute) {
            try {
                $attributeService->update('s_order_attributes', 'leopard_ausgezeichnet_org_status', 'boolean', [
                    'label' => 'ausgezeichnet.org Bewertungsmail versendet',
                    'supportText' => 'checked = Mail versendet',
                    'displayInBackend' => true,
                    'position' => 100,
                ]);
            } catch (Exception $e) {
                $this->logger->addError($e->getMessage());
            }

            $metaDataCache = Shopware()->Models()->getConfiguration()->getMetadataCacheImpl();
            $metaDataCache->deleteAll();

            Shopware()->Models()->generateAttributeModels(
                ['s_order_attributes']
            );
        }
    }

    /**
     * @param UpdateContext $context
     */
    public function update(UpdateContext $context)
    {
        if (version_compare($context->getPlugin()->getVersion(), '1.2.0', '<')) {
            $mailTemplate = Shopware()->Models()->getRepository('Shopware\Models\Mail\Mail')->findOneBy(['name' => 'ausgezeichnetorgEmail']);

            if ($mailTemplate instanceof Mail) {
                $mailTemplate->setMailtype(Mail::MAILTYPE_USER);

                try {
                    /** @var ModelManager $entityManager */
                    $entityManager = Shopware()->Models();
                    $entityManager->persist($mailTemplate);
                    $entityManager->flush();
                } catch (Exception $e) {
                    $this->logger->addError($e->getMessage());
                }
            }
        }

        if (version_compare($context->getPlugin()->getVersion(), '1.1.6', '<')) {
            $mailTemplate = Shopware()->Models()->getRepository('Shopware\Models\Mail\Mail')->findOneBy(['name' => 'ausgezeichnetorgEmail']);

            if ($mailTemplate instanceof Mail) {
                $mailTemplate_content = file_get_contents(__DIR__ . '/Resources/Mail/sOrderleopardAusgezeichnetOrg.html');
                $mailTemplate->setContentHtml($mailTemplate_content);
                $mailTemplate->setSubject('Bitte bewerten Sie uns!');

                try {
                    /** @var ModelManager $entityManager */
                    $entityManager = Shopware()->Models();
                    $entityManager->persist($mailTemplate);
                    $entityManager->flush();
                } catch (Exception $e) {
                    $this->logger->addError($e->getMessage());
                }
            }
        }

        $context->scheduleClearCache(ActivateContext::CACHE_LIST_ALL);
    }

    /**
     * @param ActivateContext $context
     */
    public function activate(ActivateContext $context)
    {
        $context->scheduleClearCache(ActivateContext::CACHE_LIST_ALL);
    }

    /**
     * @param DeactivateContext $context
     */
    public function deactivate(DeactivateContext $context)
    {
        $context->scheduleClearCache(DeactivateContext::CACHE_LIST_ALL);
    }

    /**
     * @param UninstallContext $context
     */
    public function uninstall(UninstallContext $context)
    {
        if ($context->keepUserData()) {
            return;
        }

        $mailTemplate = Shopware()->Models()->getRepository('Shopware\Models\Mail\Mail')->findOneBy(['name' => 'ausgezeichnetorgEmail']);

        if ($mailTemplate instanceof Mail) {
            try {
                /** @var ModelManager $entityManager */
                $entityManager = Shopware()->Models();
                $entityManager->remove($mailTemplate);
                $entityManager->flush();
            } catch (Exception $e) {
                $this->logger->addError($e->getMessage());
            }
        }

        $attributeService = Shopware()->Container()->get('shopware_attribute.crud_service');

        $attributeService->delete('s_order_attributes', 'leopard_ausgezeichnet_org_status');

        $metaDataCache = Shopware()->Models()->getConfiguration()->getMetadataCacheImpl();
        $metaDataCache->deleteAll();

        Shopware()->Models()->generateAttributeModels(
            ['s_order_attributes']
        );
    }
}
